package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeId, ClientRequestToken, FileSystemId}
import scala.jdk.CollectionConverters._
final case class CreateBackupRequest(
    fileSystemId: Option[FileSystemId] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    volumeId: Option[VolumeId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateBackupRequest = {
    import CreateBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateBackupRequest
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateBackupRequest.ReadOnly =
    zio.aws.fsx.model.CreateBackupRequest.wrap(buildAwsValue())
}
object CreateBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateBackupRequest =
      zio.aws.fsx.model.CreateBackupRequest(
        fileSystemId.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeId.map(value => value)
      )
    def fileSystemId: Option[FileSystemId]
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def volumeId: Option[VolumeId]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateBackupRequest
  ) extends zio.aws.fsx.model.CreateBackupRequest.ReadOnly {
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateBackupRequest
  ): zio.aws.fsx.model.CreateBackupRequest.ReadOnly = new Wrapper(impl)
}
