package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBackupResponse(
    backup: Option[zio.aws.fsx.model.Backup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateBackupResponse = {
    import CreateBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateBackupResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateBackupResponse.ReadOnly =
    zio.aws.fsx.model.CreateBackupResponse.wrap(buildAwsValue())
}
object CreateBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateBackupResponse = zio.aws.fsx.model
      .CreateBackupResponse(backup.map(value => value.asEditable))
    def backup: Option[zio.aws.fsx.model.Backup.ReadOnly]
    def getBackup: ZIO[Any, AwsError, zio.aws.fsx.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateBackupResponse
  ) extends zio.aws.fsx.model.CreateBackupResponse.ReadOnly {
    override val backup: Option[zio.aws.fsx.model.Backup.ReadOnly] = scala
      .Option(impl.backup())
      .map(value => zio.aws.fsx.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateBackupResponse
  ): zio.aws.fsx.model.CreateBackupResponse.ReadOnly = new Wrapper(impl)
}
