package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  BatchImportMetaDataOnCreate,
  Megabytes,
  Namespace,
  ClientRequestToken,
  FileSystemId,
  ArchivePath
}
import scala.jdk.CollectionConverters._
final case class CreateDataRepositoryAssociationRequest(
    fileSystemId: FileSystemId,
    fileSystemPath: Namespace,
    dataRepositoryPath: ArchivePath,
    batchImportMetaDataOnCreate: Option[BatchImportMetaDataOnCreate] = None,
    importedFileChunkSize: Option[Megabytes] = None,
    s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest = {
    import CreateDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .fileSystemPath(Namespace.unwrap(fileSystemPath): java.lang.String)
      .dataRepositoryPath(
        ArchivePath.unwrap(dataRepositoryPath): java.lang.String
      )
      .optionallyWith(
        batchImportMetaDataOnCreate.map(value =>
          BatchImportMetaDataOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.batchImportMetaDataOnCreate)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.CreateDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object CreateDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateDataRepositoryAssociationRequest =
      zio.aws.fsx.model.CreateDataRepositoryAssociationRequest(
        fileSystemId,
        fileSystemPath,
        dataRepositoryPath,
        batchImportMetaDataOnCreate.map(value => value),
        importedFileChunkSize.map(value => value),
        s3.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fileSystemId: FileSystemId
    def fileSystemPath: Namespace
    def dataRepositoryPath: ArchivePath
    def batchImportMetaDataOnCreate: Option[BatchImportMetaDataOnCreate]
    def importedFileChunkSize: Option[Megabytes]
    def s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly]
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getFileSystemPath: ZIO[Any, Nothing, Namespace] =
      ZIO.succeed(fileSystemPath)
    def getDataRepositoryPath: ZIO[Any, Nothing, ArchivePath] =
      ZIO.succeed(dataRepositoryPath)
    def getBatchImportMetaDataOnCreate
        : ZIO[Any, AwsError, BatchImportMetaDataOnCreate] =
      AwsError.unwrapOptionField(
        "batchImportMetaDataOnCreate",
        batchImportMetaDataOnCreate
      )
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val fileSystemPath: Namespace =
      zio.aws.fsx.model.primitives.Namespace(impl.fileSystemPath())
    override val dataRepositoryPath: ArchivePath =
      zio.aws.fsx.model.primitives.ArchivePath(impl.dataRepositoryPath())
    override val batchImportMetaDataOnCreate
        : Option[BatchImportMetaDataOnCreate] = scala
      .Option(impl.batchImportMetaDataOnCreate())
      .map(value =>
        zio.aws.fsx.model.primitives.BatchImportMetaDataOnCreate(value)
      )
    override val importedFileChunkSize: Option[Megabytes] = scala
      .Option(impl.importedFileChunkSize())
      .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val s3
        : Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly] =
      scala
        .Option(impl.s3())
        .map(value =>
          zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(value)
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
