package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemFromBackupResponse(
    fileSystem: Option[zio.aws.fsx.model.FileSystem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse = {
    import CreateFileSystemFromBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse
      .builder()
      .optionallyWith(fileSystem.map(value => value.buildAwsValue()))(
        _.fileSystem
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemFromBackupResponse.wrap(buildAwsValue())
}
object CreateFileSystemFromBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemFromBackupResponse =
      zio.aws.fsx.model.CreateFileSystemFromBackupResponse(
        fileSystem.map(value => value.asEditable)
      )
    def fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly]
    def getFileSystem
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
      AwsError.unwrapOptionField("fileSystem", fileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse
  ) extends zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly {
    override val fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly] =
      scala
        .Option(impl.fileSystem())
        .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse
  ): zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly =
    new Wrapper(impl)
}
