package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SubnetId,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  RouteTableId,
  WeeklyTime,
  AdminPassword,
  IpAddressRange
}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemOntapConfiguration(
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    deploymentType: zio.aws.fsx.model.OntapDeploymentType,
    endpointIpAddressRange: Option[IpAddressRange] = None,
    fsxAdminPassword: Option[AdminPassword] = None,
    diskIopsConfiguration: Option[zio.aws.fsx.model.DiskIopsConfiguration] =
      None,
    preferredSubnetId: Option[SubnetId] = None,
    routeTableIds: Option[Iterable[RouteTableId]] = None,
    throughputCapacity: MegabytesPerSecond,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemOntapConfiguration = {
    import CreateFileSystemOntapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOntapConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .deploymentType(deploymentType.unwrap)
      .optionallyWith(
        endpointIpAddressRange.map(value =>
          IpAddressRange.unwrap(value): java.lang.String
        )
      )(_.endpointIpAddressRange)
      .optionallyWith(
        fsxAdminPassword.map(value =>
          AdminPassword.unwrap(value): java.lang.String
        )
      )(_.fsxAdminPassword)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .throughputCapacity(
        MegabytesPerSecond.unwrap(throughputCapacity): Integer
      )
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemOntapConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemOntapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOntapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemOntapConfiguration =
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration(
        automaticBackupRetentionDays.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType,
        endpointIpAddressRange.map(value => value),
        fsxAdminPassword.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable),
        preferredSubnetId.map(value => value),
        routeTableIds.map(value => value),
        throughputCapacity,
        weeklyMaintenanceStartTime.map(value => value)
      )
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def deploymentType: zio.aws.fsx.model.OntapDeploymentType
    def endpointIpAddressRange: Option[IpAddressRange]
    def fsxAdminPassword: Option[AdminPassword]
    def diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def preferredSubnetId: Option[SubnetId]
    def routeTableIds: Option[List[RouteTableId]]
    def throughputCapacity: MegabytesPerSecond
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.fsx.model.OntapDeploymentType] =
      ZIO.succeed(deploymentType)
    def getEndpointIpAddressRange: ZIO[Any, AwsError, IpAddressRange] = AwsError
      .unwrapOptionField("endpointIpAddressRange", endpointIpAddressRange)
    def getFsxAdminPassword: ZIO[Any, AwsError, AdminPassword] =
      AwsError.unwrapOptionField("fsxAdminPassword", fsxAdminPassword)
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getThroughputCapacity: ZIO[Any, Nothing, MegabytesPerSecond] =
      ZIO.succeed(throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOntapConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType: zio.aws.fsx.model.OntapDeploymentType =
      zio.aws.fsx.model.OntapDeploymentType.wrap(impl.deploymentType())
    override val endpointIpAddressRange: Option[IpAddressRange] = scala
      .Option(impl.endpointIpAddressRange())
      .map(value => zio.aws.fsx.model.primitives.IpAddressRange(value))
    override val fsxAdminPassword: Option[AdminPassword] = scala
      .Option(impl.fsxAdminPassword())
      .map(value => zio.aws.fsx.model.primitives.AdminPassword(value))
    override val diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] = scala
      .Option(impl.diskIopsConfiguration())
      .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val preferredSubnetId: Option[SubnetId] = scala
      .Option(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val routeTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.RouteTableId(item)
        }.toList
      )
    override val throughputCapacity: MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond(impl.throughputCapacity())
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOntapConfiguration
  ): zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly =
    new Wrapper(impl)
}
