package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag
}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemOpenZFSConfiguration(
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    copyTagsToBackups: Option[Flag] = None,
    copyTagsToVolumes: Option[Flag] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType,
    throughputCapacity: MegabytesPerSecond,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    diskIopsConfiguration: Option[zio.aws.fsx.model.DiskIopsConfiguration] =
      None,
    rootVolumeConfiguration: Option[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration = {
    import CreateFileSystemOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        copyTagsToVolumes.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToVolumes)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .deploymentType(deploymentType.unwrap)
      .throughputCapacity(
        MegabytesPerSecond.unwrap(throughputCapacity): Integer
      )
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        rootVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.rootVolumeConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration =
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration(
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        copyTagsToVolumes.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType,
        throughputCapacity,
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable),
        rootVolumeConfiguration.map(value => value.asEditable)
      )
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Option[Flag]
    def copyTagsToVolumes: Option[Flag]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType
    def throughputCapacity: MegabytesPerSecond
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def rootVolumeConfiguration: Option[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getCopyTagsToVolumes: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToVolumes", copyTagsToVolumes)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.fsx.model.OpenZFSDeploymentType] =
      ZIO.succeed(deploymentType)
    def getThroughputCapacity: ZIO[Any, Nothing, MegabytesPerSecond] =
      ZIO.succeed(throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getRootVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootVolumeConfiguration",
      rootVolumeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Option[Flag] = scala
      .Option(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val copyTagsToVolumes: Option[Flag] = scala
      .Option(impl.copyTagsToVolumes())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType =
      zio.aws.fsx.model.OpenZFSDeploymentType.wrap(impl.deploymentType())
    override val throughputCapacity: MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond(impl.throughputCapacity())
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] = scala
      .Option(impl.diskIopsConfiguration())
      .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val rootVolumeConfiguration: Option[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ] = scala
      .Option(impl.rootVolumeConfiguration())
      .map(value =>
        zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ): zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly =
    new Wrapper(impl)
}
