package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SubnetId,
  SecurityGroupId,
  FileSystemTypeVersion,
  ClientRequestToken,
  StorageCapacity,
  KmsKeyId
}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    fileSystemType: zio.aws.fsx.model.FileSystemType,
    storageCapacity: StorageCapacity,
    storageType: Option[zio.aws.fsx.model.StorageType] = None,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    windowsConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration
    ] = None,
    lustreConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration
    ] = None,
    ontapConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration
    ] = None,
    fileSystemTypeVersion: Option[FileSystemTypeVersion] = None,
    openZFSConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest = {
    import CreateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileSystemType(fileSystemType.unwrap)
      .storageCapacity(StorageCapacity.unwrap(storageCapacity): Integer)
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        fileSystemTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileSystemTypeVersion)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemRequest.wrap(buildAwsValue())
}
object CreateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemRequest =
      zio.aws.fsx.model.CreateFileSystemRequest(
        clientRequestToken.map(value => value),
        fileSystemType,
        storageCapacity,
        storageType.map(value => value),
        subnetIds,
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        windowsConfiguration.map(value => value.asEditable),
        lustreConfiguration.map(value => value.asEditable),
        ontapConfiguration.map(value => value.asEditable),
        fileSystemTypeVersion.map(value => value),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def fileSystemType: zio.aws.fsx.model.FileSystemType
    def storageCapacity: StorageCapacity
    def storageType: Option[zio.aws.fsx.model.StorageType]
    def subnetIds: List[SubnetId]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def kmsKeyId: Option[KmsKeyId]
    def windowsConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ]
    def lustreConfiguration
        : Option[zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly]
    def ontapConfiguration
        : Option[zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly]
    def fileSystemTypeVersion: Option[FileSystemTypeVersion]
    def openZFSConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileSystemType: ZIO[Any, Nothing, zio.aws.fsx.model.FileSystemType] =
      ZIO.succeed(fileSystemType)
    def getStorageCapacity: ZIO[Any, Nothing, StorageCapacity] =
      ZIO.succeed(storageCapacity)
    def getStorageType: ZIO[Any, AwsError, zio.aws.fsx.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getFileSystemTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileSystemTypeVersion", fileSystemTypeVersion)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ) extends zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileSystemType: zio.aws.fsx.model.FileSystemType =
      zio.aws.fsx.model.FileSystemType.wrap(impl.fileSystemType())
    override val storageCapacity: StorageCapacity =
      zio.aws.fsx.model.primitives.StorageCapacity(impl.storageCapacity())
    override val storageType: Option[zio.aws.fsx.model.StorageType] = scala
      .Option(impl.storageType())
      .map(value => zio.aws.fsx.model.StorageType.wrap(value))
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val windowsConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = scala
      .Option(impl.windowsConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.wrap(value)
      )
    override val lustreConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = scala
      .Option(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemLustreConfiguration.wrap(value)
      )
    override val ontapConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly
    ] = scala
      .Option(impl.ontapConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemOntapConfiguration.wrap(value)
      )
    override val fileSystemTypeVersion: Option[FileSystemTypeVersion] = scala
      .Option(impl.fileSystemTypeVersion())
      .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val openZFSConfiguration: Option[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = scala
      .Option(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ): zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly = new Wrapper(impl)
}
