package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SubnetId,
  AlternateDNSName,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag,
  DirectoryId
}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemWindowsConfiguration(
    activeDirectoryId: Option[DirectoryId] = None,
    selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration
    ] = None,
    deploymentType: Option[zio.aws.fsx.model.WindowsDeploymentType] = None,
    preferredSubnetId: Option[SubnetId] = None,
    throughputCapacity: MegabytesPerSecond,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    copyTagsToBackups: Option[Flag] = None,
    aliases: Option[Iterable[AlternateDNSName]] = None,
    auditLogConfiguration: Option[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration = {
    import CreateFileSystemWindowsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryId.map(value =>
          DirectoryId.unwrap(value): java.lang.String
        )
      )(_.activeDirectoryId)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .throughputCapacity(
        MegabytesPerSecond.unwrap(throughputCapacity): Integer
      )
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            AlternateDNSName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        auditLogConfiguration.map(value => value.buildAwsValue())
      )(_.auditLogConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemWindowsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemWindowsConfiguration =
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration(
        activeDirectoryId.map(value => value),
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable),
        deploymentType.map(value => value),
        preferredSubnetId.map(value => value),
        throughputCapacity,
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        aliases.map(value => value),
        auditLogConfiguration.map(value => value.asEditable)
      )
    def activeDirectoryId: Option[DirectoryId]
    def selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ]
    def deploymentType: Option[zio.aws.fsx.model.WindowsDeploymentType]
    def preferredSubnetId: Option[SubnetId]
    def throughputCapacity: MegabytesPerSecond
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Option[Flag]
    def aliases: Option[List[AlternateDNSName]]
    def auditLogConfiguration
        : Option[zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly]
    def getActiveDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("activeDirectoryId", activeDirectoryId)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.WindowsDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getThroughputCapacity: ZIO[Any, Nothing, MegabytesPerSecond] =
      ZIO.succeed(throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getAliases: ZIO[Any, AwsError, List[AlternateDNSName]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getAuditLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("auditLogConfiguration", auditLogConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly {
    override val activeDirectoryId: Option[DirectoryId] = scala
      .Option(impl.activeDirectoryId())
      .map(value => zio.aws.fsx.model.primitives.DirectoryId(value))
    override val selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = scala
      .Option(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.wrap(value)
      )
    override val deploymentType
        : Option[zio.aws.fsx.model.WindowsDeploymentType] = scala
      .Option(impl.deploymentType())
      .map(value => zio.aws.fsx.model.WindowsDeploymentType.wrap(value))
    override val preferredSubnetId: Option[SubnetId] = scala
      .Option(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val throughputCapacity: MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond(impl.throughputCapacity())
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Option[Flag] = scala
      .Option(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val aliases: Option[List[AlternateDNSName]] = scala
      .Option(impl.aliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.AlternateDNSName(item)
        }.toList
      )
    override val auditLogConfiguration: Option[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] = scala
      .Option(impl.auditLogConfiguration())
      .map(value =>
        zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ): zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly =
    new Wrapper(impl)
}
