package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    snapshot: Option[zio.aws.fsx.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateSnapshotResponse = zio.aws.fsx.model
      .CreateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ) extends zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.fsx.model.Snapshot.ReadOnly] = scala
      .Option(impl.snapshot())
      .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ): zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
