package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NetBiosAlias
import scala.jdk.CollectionConverters._
final case class CreateSvmActiveDirectoryConfiguration(
    netBiosName: NetBiosAlias,
    selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration = {
    import CreateSvmActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration
      .builder()
      .netBiosName(NetBiosAlias.unwrap(netBiosName): java.lang.String)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration
      .wrap(buildAwsValue())
}
object CreateSvmActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration =
      zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration(
        netBiosName,
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable)
      )
    def netBiosName: NetBiosAlias
    def selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ]
    def getNetBiosName: ZIO[Any, Nothing, NetBiosAlias] =
      ZIO.succeed(netBiosName)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration
  ) extends zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly {
    override val netBiosName: NetBiosAlias =
      zio.aws.fsx.model.primitives.NetBiosAlias(impl.netBiosName())
    override val selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = scala
      .Option(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration
  ): zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly =
    new Wrapper(impl)
}
