package zio.aws.fsx.model
import java.time.Instant
import zio.aws.fsx.model.primitives.{
  CreationTime,
  BatchImportMetaDataOnCreate,
  Megabytes,
  Namespace,
  FileSystemId,
  ResourceARN,
  ArchivePath,
  DataRepositoryAssociationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DataRepositoryAssociation(
    associationId: Option[DataRepositoryAssociationId] = None,
    resourceARN: Option[ResourceARN] = None,
    fileSystemId: Option[FileSystemId] = None,
    lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle] = None,
    failureDetails: Option[zio.aws.fsx.model.DataRepositoryFailureDetails] =
      None,
    fileSystemPath: Option[Namespace] = None,
    dataRepositoryPath: Option[ArchivePath] = None,
    batchImportMetaDataOnCreate: Option[BatchImportMetaDataOnCreate] = None,
    importedFileChunkSize: Option[Megabytes] = None,
    s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    creationTime: Option[CreationTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation = {
    import DataRepositoryAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DataRepositoryAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(
        fileSystemPath.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.fileSystemPath)
      .optionallyWith(
        dataRepositoryPath.map(value =>
          ArchivePath.unwrap(value): java.lang.String
        )
      )(_.dataRepositoryPath)
      .optionallyWith(
        batchImportMetaDataOnCreate.map(value =>
          BatchImportMetaDataOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.batchImportMetaDataOnCreate)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly =
    zio.aws.fsx.model.DataRepositoryAssociation.wrap(buildAwsValue())
}
object DataRepositoryAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryAssociation =
      zio.aws.fsx.model.DataRepositoryAssociation(
        associationId.map(value => value),
        resourceARN.map(value => value),
        fileSystemId.map(value => value),
        lifecycle.map(value => value),
        failureDetails.map(value => value.asEditable),
        fileSystemPath.map(value => value),
        dataRepositoryPath.map(value => value),
        batchImportMetaDataOnCreate.map(value => value),
        importedFileChunkSize.map(value => value),
        s3.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value)
      )
    def associationId: Option[DataRepositoryAssociationId]
    def resourceARN: Option[ResourceARN]
    def fileSystemId: Option[FileSystemId]
    def lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle]
    def failureDetails
        : Option[zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly]
    def fileSystemPath: Option[Namespace]
    def dataRepositoryPath: Option[ArchivePath]
    def batchImportMetaDataOnCreate: Option[BatchImportMetaDataOnCreate]
    def importedFileChunkSize: Option[Megabytes]
    def s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def creationTime: Option[CreationTime]
    def getAssociationId: ZIO[Any, AwsError, DataRepositoryAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getFileSystemPath: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("fileSystemPath", fileSystemPath)
    def getDataRepositoryPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("dataRepositoryPath", dataRepositoryPath)
    def getBatchImportMetaDataOnCreate
        : ZIO[Any, AwsError, BatchImportMetaDataOnCreate] =
      AwsError.unwrapOptionField(
        "batchImportMetaDataOnCreate",
        batchImportMetaDataOnCreate
      )
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation
  ) extends zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly {
    override val associationId: Option[DataRepositoryAssociationId] = scala
      .Option(impl.associationId())
      .map(value =>
        zio.aws.fsx.model.primitives.DataRepositoryAssociationId(value)
      )
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.fsx.model.DataRepositoryLifecycle.wrap(value))
    override val failureDetails
        : Option[zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly] =
      scala
        .Option(impl.failureDetails())
        .map(value =>
          zio.aws.fsx.model.DataRepositoryFailureDetails.wrap(value)
        )
    override val fileSystemPath: Option[Namespace] = scala
      .Option(impl.fileSystemPath())
      .map(value => zio.aws.fsx.model.primitives.Namespace(value))
    override val dataRepositoryPath: Option[ArchivePath] = scala
      .Option(impl.dataRepositoryPath())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val batchImportMetaDataOnCreate
        : Option[BatchImportMetaDataOnCreate] = scala
      .Option(impl.batchImportMetaDataOnCreate())
      .map(value =>
        zio.aws.fsx.model.primitives.BatchImportMetaDataOnCreate(value)
      )
    override val importedFileChunkSize: Option[Megabytes] = scala
      .Option(impl.importedFileChunkSize())
      .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val s3
        : Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly] =
      scala
        .Option(impl.s3())
        .map(value =>
          zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(value)
        )
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation
  ): zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly = new Wrapper(impl)
}
