package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DeleteDataInFileSystem,
  ClientRequestToken,
  DataRepositoryAssociationId
}
import scala.jdk.CollectionConverters._
final case class DeleteDataRepositoryAssociationRequest(
    associationId: DataRepositoryAssociationId,
    clientRequestToken: Option[ClientRequestToken] = None,
    deleteDataInFileSystem: DeleteDataInFileSystem
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest = {
    import DeleteDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
      .builder()
      .associationId(
        DataRepositoryAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .deleteDataInFileSystem(
        DeleteDataInFileSystem.unwrap(deleteDataInFileSystem): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest =
      zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest(
        associationId,
        clientRequestToken.map(value => value),
        deleteDataInFileSystem
      )
    def associationId: DataRepositoryAssociationId
    def clientRequestToken: Option[ClientRequestToken]
    def deleteDataInFileSystem: DeleteDataInFileSystem
    def getAssociationId: ZIO[Any, Nothing, DataRepositoryAssociationId] =
      ZIO.succeed(associationId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDeleteDataInFileSystem: ZIO[Any, Nothing, DeleteDataInFileSystem] =
      ZIO.succeed(deleteDataInFileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly {
    override val associationId: DataRepositoryAssociationId =
      zio.aws.fsx.model.primitives
        .DataRepositoryAssociationId(impl.associationId())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val deleteDataInFileSystem: DeleteDataInFileSystem =
      zio.aws.fsx.model.primitives
        .DeleteDataInFileSystem(impl.deleteDataInFileSystem())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
