package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DeleteDataInFileSystem,
  DataRepositoryAssociationId
}
import scala.jdk.CollectionConverters._
final case class DeleteDataRepositoryAssociationResponse(
    associationId: Option[DataRepositoryAssociationId] = None,
    lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle] = None,
    deleteDataInFileSystem: Option[DeleteDataInFileSystem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse = {
    import DeleteDataRepositoryAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DataRepositoryAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        deleteDataInFileSystem.map(value =>
          DeleteDataInFileSystem.unwrap(value): java.lang.Boolean
        )
      )(_.deleteDataInFileSystem)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly =
    zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse
      .wrap(buildAwsValue())
}
object DeleteDataRepositoryAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse =
      zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse(
        associationId.map(value => value),
        lifecycle.map(value => value),
        deleteDataInFileSystem.map(value => value)
      )
    def associationId: Option[DataRepositoryAssociationId]
    def lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle]
    def deleteDataInFileSystem: Option[DeleteDataInFileSystem]
    def getAssociationId: ZIO[Any, AwsError, DataRepositoryAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getDeleteDataInFileSystem: ZIO[Any, AwsError, DeleteDataInFileSystem] =
      AwsError.unwrapOptionField(
        "deleteDataInFileSystem",
        deleteDataInFileSystem
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse
  ) extends zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly {
    override val associationId: Option[DataRepositoryAssociationId] = scala
      .Option(impl.associationId())
      .map(value =>
        zio.aws.fsx.model.primitives.DataRepositoryAssociationId(value)
      )
    override val lifecycle: Option[zio.aws.fsx.model.DataRepositoryLifecycle] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.fsx.model.DataRepositoryLifecycle.wrap(value))
    override val deleteDataInFileSystem: Option[DeleteDataInFileSystem] = scala
      .Option(impl.deleteDataInFileSystem())
      .map(value => zio.aws.fsx.model.primitives.DeleteDataInFileSystem(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse
  ): zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
