package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemResponse(
    fileSystemId: Option[FileSystemId] = None,
    lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle] = None,
    windowsResponse: Option[zio.aws.fsx.model.DeleteFileSystemWindowsResponse] =
      None,
    lustreResponse: Option[zio.aws.fsx.model.DeleteFileSystemLustreResponse] =
      None,
    openZFSResponse: Option[zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse = {
    import DeleteFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(windowsResponse.map(value => value.buildAwsValue()))(
        _.windowsResponse
      )
      .optionallyWith(lustreResponse.map(value => value.buildAwsValue()))(
        _.lustreResponse
      )
      .optionallyWith(openZFSResponse.map(value => value.buildAwsValue()))(
        _.openZFSResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemResponse.wrap(buildAwsValue())
}
object DeleteFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemResponse =
      zio.aws.fsx.model.DeleteFileSystemResponse(
        fileSystemId.map(value => value),
        lifecycle.map(value => value),
        windowsResponse.map(value => value.asEditable),
        lustreResponse.map(value => value.asEditable),
        openZFSResponse.map(value => value.asEditable)
      )
    def fileSystemId: Option[FileSystemId]
    def lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle]
    def windowsResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly]
    def lustreResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly]
    def openZFSResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getWindowsResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("windowsResponse", windowsResponse)
    def getLustreResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly
    ] = AwsError.unwrapOptionField("lustreResponse", lustreResponse)
    def getOpenZFSResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSResponse", openZFSResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ) extends zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly {
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileSystemLifecycle.wrap(value))
    override val windowsResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly] =
      scala
        .Option(impl.windowsResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemWindowsResponse.wrap(value)
        )
    override val lustreResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly] =
      scala
        .Option(impl.lustreResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemLustreResponse.wrap(value)
        )
    override val openZFSResponse
        : Option[zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly] =
      scala
        .Option(impl.openZFSResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ): zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly = new Wrapper(impl)
}
