package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.BackupId
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemWindowsResponse(
    finalBackupId: Option[BackupId] = None,
    finalBackupTags: Option[Iterable[zio.aws.fsx.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse = {
    import DeleteFileSystemWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse
      .builder()
      .optionallyWith(
        finalBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.finalBackupId)
      .optionallyWith(
        finalBackupTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalBackupTags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemWindowsResponse.wrap(buildAwsValue())
}
object DeleteFileSystemWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemWindowsResponse =
      zio.aws.fsx.model.DeleteFileSystemWindowsResponse(
        finalBackupId.map(value => value),
        finalBackupTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def finalBackupId: Option[BackupId]
    def finalBackupTags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getFinalBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("finalBackupId", finalBackupId)
    def getFinalBackupTags
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("finalBackupTags", finalBackupTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse
  ) extends zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly {
    override val finalBackupId: Option[BackupId] = scala
      .Option(impl.finalBackupId())
      .map(value => zio.aws.fsx.model.primitives.BackupId(value))
    override val finalBackupTags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      scala
        .Option(impl.finalBackupTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse
  ): zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly = new Wrapper(
    impl
  )
}
