package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{SnapshotId, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    snapshotId: SnapshotId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteSnapshotRequest.ReadOnly =
    zio.aws.fsx.model.DeleteSnapshotRequest.wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteSnapshotRequest = zio.aws.fsx.model
      .DeleteSnapshotRequest(clientRequestToken.map(value => value), snapshotId)
    def clientRequestToken: Option[ClientRequestToken]
    def snapshotId: SnapshotId
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest
  ) extends zio.aws.fsx.model.DeleteSnapshotRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val snapshotId: SnapshotId =
      zio.aws.fsx.model.primitives.SnapshotId(impl.snapshotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest
  ): zio.aws.fsx.model.DeleteSnapshotRequest.ReadOnly = new Wrapper(impl)
}
