package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  StorageVirtualMachineId,
  ClientRequestToken
}
import scala.jdk.CollectionConverters._
final case class DeleteStorageVirtualMachineRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    storageVirtualMachineId: StorageVirtualMachineId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest = {
    import DeleteStorageVirtualMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .storageVirtualMachineId(
        StorageVirtualMachineId.unwrap(
          storageVirtualMachineId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteStorageVirtualMachineRequest.ReadOnly =
    zio.aws.fsx.model.DeleteStorageVirtualMachineRequest.wrap(buildAwsValue())
}
object DeleteStorageVirtualMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteStorageVirtualMachineRequest =
      zio.aws.fsx.model.DeleteStorageVirtualMachineRequest(
        clientRequestToken.map(value => value),
        storageVirtualMachineId
      )
    def clientRequestToken: Option[ClientRequestToken]
    def storageVirtualMachineId: StorageVirtualMachineId
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getStorageVirtualMachineId: ZIO[Any, Nothing, StorageVirtualMachineId] =
      ZIO.succeed(storageVirtualMachineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest
  ) extends zio.aws.fsx.model.DeleteStorageVirtualMachineRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val storageVirtualMachineId: StorageVirtualMachineId =
      zio.aws.fsx.model.primitives
        .StorageVirtualMachineId(impl.storageVirtualMachineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest
  ): zio.aws.fsx.model.DeleteStorageVirtualMachineRequest.ReadOnly =
    new Wrapper(impl)
}
