package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.StorageVirtualMachineId
import scala.jdk.CollectionConverters._
final case class DeleteStorageVirtualMachineResponse(
    storageVirtualMachineId: Option[StorageVirtualMachineId] = None,
    lifecycle: Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse = {
    import DeleteStorageVirtualMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse
      .builder()
      .optionallyWith(
        storageVirtualMachineId.map(value =>
          StorageVirtualMachineId.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly =
    zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.wrap(buildAwsValue())
}
object DeleteStorageVirtualMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteStorageVirtualMachineResponse =
      zio.aws.fsx.model.DeleteStorageVirtualMachineResponse(
        storageVirtualMachineId.map(value => value),
        lifecycle.map(value => value)
      )
    def storageVirtualMachineId: Option[StorageVirtualMachineId]
    def lifecycle: Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle]
    def getStorageVirtualMachineId
        : ZIO[Any, AwsError, StorageVirtualMachineId] = AwsError
      .unwrapOptionField("storageVirtualMachineId", storageVirtualMachineId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachineLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse
  ) extends zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly {
    override val storageVirtualMachineId: Option[StorageVirtualMachineId] =
      scala
        .Option(impl.storageVirtualMachineId())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(value)
        )
    override val lifecycle
        : Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value =>
        zio.aws.fsx.model.StorageVirtualMachineLifecycle.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse
  ): zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly =
    new Wrapper(impl)
}
