package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteVolumeOpenZFSConfiguration(
    options: Option[Iterable[zio.aws.fsx.model.DeleteOpenZFSVolumeOption]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteVolumeOpenZFSConfiguration = {
    import DeleteVolumeOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteVolumeOpenZFSConfiguration
      .builder()
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.wrap(buildAwsValue())
}
object DeleteVolumeOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteVolumeOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration =
      zio.aws.fsx.model
        .DeleteVolumeOpenZFSConfiguration(options.map(value => value))
    def options: Option[List[zio.aws.fsx.model.DeleteOpenZFSVolumeOption]]
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DeleteOpenZFSVolumeOption
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeOpenZFSConfiguration
  ) extends zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly {
    override val options
        : Option[List[zio.aws.fsx.model.DeleteOpenZFSVolumeOption]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.DeleteOpenZFSVolumeOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeOpenZFSConfiguration
  ): zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
