package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeId, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class DeleteVolumeRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    volumeId: VolumeId,
    ontapConfiguration: Option[
      zio.aws.fsx.model.DeleteVolumeOntapConfiguration
    ] = None,
    openZFSConfiguration: Option[
      zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest = {
    import DeleteVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteVolumeRequest.ReadOnly =
    zio.aws.fsx.model.DeleteVolumeRequest.wrap(buildAwsValue())
}
object DeleteVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteVolumeRequest =
      zio.aws.fsx.model.DeleteVolumeRequest(
        clientRequestToken.map(value => value),
        volumeId,
        ontapConfiguration.map(value => value.asEditable),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def volumeId: VolumeId
    def ontapConfiguration
        : Option[zio.aws.fsx.model.DeleteVolumeOntapConfiguration.ReadOnly]
    def openZFSConfiguration
        : Option[zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteVolumeOntapConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest
  ) extends zio.aws.fsx.model.DeleteVolumeRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val volumeId: VolumeId =
      zio.aws.fsx.model.primitives.VolumeId(impl.volumeId())
    override val ontapConfiguration
        : Option[zio.aws.fsx.model.DeleteVolumeOntapConfiguration.ReadOnly] =
      scala
        .Option(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.DeleteVolumeOntapConfiguration.wrap(value)
        )
    override val openZFSConfiguration
        : Option[zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.ReadOnly] =
      scala
        .Option(impl.openZFSConfiguration())
        .map(value =>
          zio.aws.fsx.model.DeleteVolumeOpenZFSConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest
  ): zio.aws.fsx.model.DeleteVolumeRequest.ReadOnly = new Wrapper(impl)
}
