package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.VolumeId
import scala.jdk.CollectionConverters._
final case class DeleteVolumeResponse(
    volumeId: Option[VolumeId] = None,
    lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = None,
    ontapResponse: Option[zio.aws.fsx.model.DeleteVolumeOntapResponse] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse = {
    import DeleteVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse
      .builder()
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(ontapResponse.map(value => value.buildAwsValue()))(
        _.ontapResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly =
    zio.aws.fsx.model.DeleteVolumeResponse.wrap(buildAwsValue())
}
object DeleteVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteVolumeResponse =
      zio.aws.fsx.model.DeleteVolumeResponse(
        volumeId.map(value => value),
        lifecycle.map(value => value),
        ontapResponse.map(value => value.asEditable)
      )
    def volumeId: Option[VolumeId]
    def lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle]
    def ontapResponse
        : Option[zio.aws.fsx.model.DeleteVolumeOntapResponse.ReadOnly]
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getOntapResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteVolumeOntapResponse.ReadOnly
    ] = AwsError.unwrapOptionField("ontapResponse", ontapResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse
  ) extends zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly {
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.fsx.model.VolumeLifecycle.wrap(value))
    override val ontapResponse
        : Option[zio.aws.fsx.model.DeleteVolumeOntapResponse.ReadOnly] = scala
      .Option(impl.ontapResponse())
      .map(value => zio.aws.fsx.model.DeleteVolumeOntapResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse
  ): zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly = new Wrapper(impl)
}
