package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, BackupId}
import scala.jdk.CollectionConverters._
final case class DescribeBackupsRequest(
    backupIds: Option[Iterable[BackupId]] = None,
    filters: Option[Iterable[zio.aws.fsx.model.Filter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        backupIds.map(value =>
          value.map { item =>
            BackupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.backupIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeBackupsRequest =
      zio.aws.fsx.model.DescribeBackupsRequest(
        backupIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def backupIds: Option[List[BackupId]]
    def filters: Option[List[zio.aws.fsx.model.Filter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBackupIds: ZIO[Any, AwsError, List[BackupId]] =
      AwsError.unwrapOptionField("backupIds", backupIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ) extends zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly {
    override val backupIds: Option[List[BackupId]] = scala
      .Option(impl.backupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.BackupId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.fsx.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ): zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly = new Wrapper(impl)
}
