package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeBackupsResponse(
    backups: Option[Iterable[zio.aws.fsx.model.Backup]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse = {
    import DescribeBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse
      .builder()
      .optionallyWith(
        backups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly =
    zio.aws.fsx.model.DescribeBackupsResponse.wrap(buildAwsValue())
}
object DescribeBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeBackupsResponse =
      zio.aws.fsx.model.DescribeBackupsResponse(
        backups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backups: Option[List[zio.aws.fsx.model.Backup.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBackups
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Backup.ReadOnly]] =
      AwsError.unwrapOptionField("backups", backups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse
  ) extends zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly {
    override val backups: Option[List[zio.aws.fsx.model.Backup.ReadOnly]] =
      scala
        .Option(impl.backups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Backup.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse
  ): zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly = new Wrapper(impl)
}
