package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeDataRepositoryAssociationsResponse(
    associations: Option[
      Iterable[zio.aws.fsx.model.DataRepositoryAssociation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse = {
    import DescribeDataRepositoryAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly =
    zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeDataRepositoryAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse =
      zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations
        : Option[List[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ) extends zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly {
    override val associations
        : Option[List[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]] =
      scala
        .Option(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.DataRepositoryAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ): zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
