package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, TaskId}
import scala.jdk.CollectionConverters._
final case class DescribeDataRepositoryTasksRequest(
    taskIds: Option[Iterable[TaskId]] = None,
    filters: Option[Iterable[zio.aws.fsx.model.DataRepositoryTaskFilter]] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest = {
    import DescribeDataRepositoryTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest
      .builder()
      .optionallyWith(
        taskIds.map(value =>
          value.map { item =>
            TaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeDataRepositoryTasksRequest.ReadOnly =
    zio.aws.fsx.model.DescribeDataRepositoryTasksRequest.wrap(buildAwsValue())
}
object DescribeDataRepositoryTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeDataRepositoryTasksRequest =
      zio.aws.fsx.model.DescribeDataRepositoryTasksRequest(
        taskIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskIds: Option[List[TaskId]]
    def filters
        : Option[List[zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getTaskIds: ZIO[Any, AwsError, List[TaskId]] =
      AwsError.unwrapOptionField("taskIds", taskIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest
  ) extends zio.aws.fsx.model.DescribeDataRepositoryTasksRequest.ReadOnly {
    override val taskIds: Option[List[TaskId]] = scala
      .Option(impl.taskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.TaskId(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.DataRepositoryTaskFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest
  ): zio.aws.fsx.model.DescribeDataRepositoryTasksRequest.ReadOnly =
    new Wrapper(impl)
}
