package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeDataRepositoryTasksResponse(
    dataRepositoryTasks: Option[
      Iterable[zio.aws.fsx.model.DataRepositoryTask]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse = {
    import DescribeDataRepositoryTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse
      .builder()
      .optionallyWith(
        dataRepositoryTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataRepositoryTasks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly =
    zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.wrap(buildAwsValue())
}
object DescribeDataRepositoryTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeDataRepositoryTasksResponse =
      zio.aws.fsx.model.DescribeDataRepositoryTasksResponse(
        dataRepositoryTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataRepositoryTasks
        : Option[List[zio.aws.fsx.model.DataRepositoryTask.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDataRepositoryTasks: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DataRepositoryTask.ReadOnly
    ]] = AwsError.unwrapOptionField("dataRepositoryTasks", dataRepositoryTasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse
  ) extends zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly {
    override val dataRepositoryTasks
        : Option[List[zio.aws.fsx.model.DataRepositoryTask.ReadOnly]] = scala
      .Option(impl.dataRepositoryTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.DataRepositoryTask.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse
  ): zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly =
    new Wrapper(impl)
}
