package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemAliasesResponse(
    aliases: Option[Iterable[zio.aws.fsx.model.Alias]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse = {
    import DescribeFileSystemAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
      .builder()
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemAliasesResponse.wrap(buildAwsValue())
}
object DescribeFileSystemAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemAliasesResponse =
      zio.aws.fsx.model.DescribeFileSystemAliasesResponse(
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aliases: Option[List[zio.aws.fsx.model.Alias.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAliases: ZIO[Any, AwsError, List[zio.aws.fsx.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ) extends zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly {
    override val aliases: Option[List[zio.aws.fsx.model.Alias.ReadOnly]] = scala
      .Option(impl.aliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Alias.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ): zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
