package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, FileSystemId}
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsRequest(
    fileSystemIds: Option[Iterable[FileSystemId]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest = {
    import DescribeFileSystemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
      .builder()
      .optionallyWith(
        fileSystemIds.map(value =>
          value.map { item =>
            FileSystemId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fileSystemIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemsRequest.wrap(buildAwsValue())
}
object DescribeFileSystemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemsRequest =
      zio.aws.fsx.model.DescribeFileSystemsRequest(
        fileSystemIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def fileSystemIds: Option[List[FileSystemId]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getFileSystemIds: ZIO[Any, AwsError, List[FileSystemId]] =
      AwsError.unwrapOptionField("fileSystemIds", fileSystemIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ) extends zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly {
    override val fileSystemIds: Option[List[FileSystemId]] = scala
      .Option(impl.fileSystemIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.FileSystemId(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ): zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly = new Wrapper(impl)
}
