package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, SnapshotId}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsRequest(
    snapshotIds: Option[Iterable[SnapshotId]] = None,
    filters: Option[Iterable[zio.aws.fsx.model.SnapshotFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(
        snapshotIds.map(value =>
          value.map { item =>
            SnapshotId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeSnapshotsRequest =
      zio.aws.fsx.model.DescribeSnapshotsRequest(
        snapshotIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def snapshotIds: Option[List[SnapshotId]]
    def filters: Option[List[zio.aws.fsx.model.SnapshotFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getSnapshotIds: ZIO[Any, AwsError, List[SnapshotId]] =
      AwsError.unwrapOptionField("snapshotIds", snapshotIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.SnapshotFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest
  ) extends zio.aws.fsx.model.DescribeSnapshotsRequest.ReadOnly {
    override val snapshotIds: Option[List[SnapshotId]] = scala
      .Option(impl.snapshotIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.SnapshotId(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.fsx.model.SnapshotFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.SnapshotFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest
  ): zio.aws.fsx.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
