package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  NextToken,
  MaxResults,
  StorageVirtualMachineId
}
import scala.jdk.CollectionConverters._
final case class DescribeStorageVirtualMachinesRequest(
    storageVirtualMachineIds: Option[Iterable[StorageVirtualMachineId]] = None,
    filters: Option[Iterable[zio.aws.fsx.model.StorageVirtualMachineFilter]] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest = {
    import DescribeStorageVirtualMachinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
      .builder()
      .optionallyWith(
        storageVirtualMachineIds.map(value =>
          value.map { item =>
            StorageVirtualMachineId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.storageVirtualMachineIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly =
    zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest
      .wrap(buildAwsValue())
}
object DescribeStorageVirtualMachinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest =
      zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest(
        storageVirtualMachineIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def storageVirtualMachineIds: Option[List[StorageVirtualMachineId]]
    def filters
        : Option[List[zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getStorageVirtualMachineIds
        : ZIO[Any, AwsError, List[StorageVirtualMachineId]] = AwsError
      .unwrapOptionField("storageVirtualMachineIds", storageVirtualMachineIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ) extends zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly {
    override val storageVirtualMachineIds
        : Option[List[StorageVirtualMachineId]] = scala
      .Option(impl.storageVirtualMachineIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.StorageVirtualMachineFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ): zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly =
    new Wrapper(impl)
}
