package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateFileSystemAliasesResponse(
    aliases: Option[Iterable[zio.aws.fsx.model.Alias]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse = {
    import DisassociateFileSystemAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse
      .builder()
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly =
    zio.aws.fsx.model.DisassociateFileSystemAliasesResponse
      .wrap(buildAwsValue())
}
object DisassociateFileSystemAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DisassociateFileSystemAliasesResponse =
      zio.aws.fsx.model.DisassociateFileSystemAliasesResponse(
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def aliases: Option[List[zio.aws.fsx.model.Alias.ReadOnly]]
    def getAliases: ZIO[Any, AwsError, List[zio.aws.fsx.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse
  ) extends zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly {
    override val aliases: Option[List[zio.aws.fsx.model.Alias.ReadOnly]] = scala
      .Option(impl.aliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Alias.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse
  ): zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly =
    new Wrapper(impl)
}
