package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.Iops
import scala.jdk.CollectionConverters._
final case class DiskIopsConfiguration(
    mode: Option[zio.aws.fsx.model.DiskIopsConfigurationMode] = None,
    iops: Option[Iops] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration = {
    import DiskIopsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(iops.map(value => Iops.unwrap(value): java.lang.Long))(
        _.iops
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly =
    zio.aws.fsx.model.DiskIopsConfiguration.wrap(buildAwsValue())
}
object DiskIopsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DiskIopsConfiguration = zio.aws.fsx.model
      .DiskIopsConfiguration(mode.map(value => value), iops.map(value => value))
    def mode: Option[zio.aws.fsx.model.DiskIopsConfigurationMode]
    def iops: Option[Iops]
    def getMode
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfigurationMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getIops: ZIO[Any, AwsError, Iops] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ) extends zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly {
    override val mode: Option[zio.aws.fsx.model.DiskIopsConfigurationMode] =
      scala
        .Option(impl.mode())
        .map(value => zio.aws.fsx.model.DiskIopsConfigurationMode.wrap(value))
    override val iops: Option[Iops] = scala
      .Option(impl.iops())
      .map(value => zio.aws.fsx.model.primitives.Iops(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ): zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly = new Wrapper(impl)
}
