package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait DiskIopsConfigurationMode {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode
}
object DiskIopsConfigurationMode {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode
  ): zio.aws.fsx.model.DiskIopsConfigurationMode = value match {
    case software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.USER_PROVISIONED =>
      val r = USER_PROVISIONED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DiskIopsConfigurationMode {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode =
      software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.fsx.model.DiskIopsConfigurationMode {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode =
      software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.AUTOMATIC
  }
  case object USER_PROVISIONED
      extends zio.aws.fsx.model.DiskIopsConfigurationMode {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode =
      software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode.USER_PROVISIONED
  }
}
