package zio.aws.fsx.model
import java.time.Instant
import zio.aws.fsx.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  DNSName,
  NetworkInterfaceId,
  FileSystemTypeVersion,
  StorageCapacity,
  FileSystemId,
  AWSAccountId,
  ResourceARN,
  KmsKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FileSystem(
    ownerId: Option[AWSAccountId] = None,
    creationTime: Option[CreationTime] = None,
    fileSystemId: Option[FileSystemId] = None,
    fileSystemType: Option[zio.aws.fsx.model.FileSystemType] = None,
    lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle] = None,
    failureDetails: Option[zio.aws.fsx.model.FileSystemFailureDetails] = None,
    storageCapacity: Option[StorageCapacity] = None,
    storageType: Option[zio.aws.fsx.model.StorageType] = None,
    vpcId: Option[VpcId] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    networkInterfaceIds: Option[Iterable[NetworkInterfaceId]] = None,
    dnsName: Option[DNSName] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    resourceARN: Option[ResourceARN] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    windowsConfiguration: Option[
      zio.aws.fsx.model.WindowsFileSystemConfiguration
    ] = None,
    lustreConfiguration: Option[
      zio.aws.fsx.model.LustreFileSystemConfiguration
    ] = None,
    administrativeActions: Option[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = None,
    ontapConfiguration: Option[zio.aws.fsx.model.OntapFileSystemConfiguration] =
      None,
    fileSystemTypeVersion: Option[FileSystemTypeVersion] = None,
    openZFSConfiguration: Option[
      zio.aws.fsx.model.OpenZFSFileSystemConfiguration
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.FileSystem = {
    import FileSystem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileSystem
      .builder()
      .optionallyWith(
        ownerId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(fileSystemType.map(value => value.unwrap))(
        _.fileSystemType
      )
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(
        storageCapacity.map(value => StorageCapacity.unwrap(value): Integer)
      )(_.storageCapacity)
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        fileSystemTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileSystemTypeVersion)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileSystem.ReadOnly =
    zio.aws.fsx.model.FileSystem.wrap(buildAwsValue())
}
object FileSystem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.FileSystem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileSystem = zio.aws.fsx.model.FileSystem(
      ownerId.map(value => value),
      creationTime.map(value => value),
      fileSystemId.map(value => value),
      fileSystemType.map(value => value),
      lifecycle.map(value => value),
      failureDetails.map(value => value.asEditable),
      storageCapacity.map(value => value),
      storageType.map(value => value),
      vpcId.map(value => value),
      subnetIds.map(value => value),
      networkInterfaceIds.map(value => value),
      dnsName.map(value => value),
      kmsKeyId.map(value => value),
      resourceARN.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      windowsConfiguration.map(value => value.asEditable),
      lustreConfiguration.map(value => value.asEditable),
      administrativeActions.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      ontapConfiguration.map(value => value.asEditable),
      fileSystemTypeVersion.map(value => value),
      openZFSConfiguration.map(value => value.asEditable)
    )
    def ownerId: Option[AWSAccountId]
    def creationTime: Option[CreationTime]
    def fileSystemId: Option[FileSystemId]
    def fileSystemType: Option[zio.aws.fsx.model.FileSystemType]
    def lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle]
    def failureDetails
        : Option[zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly]
    def storageCapacity: Option[StorageCapacity]
    def storageType: Option[zio.aws.fsx.model.StorageType]
    def vpcId: Option[VpcId]
    def subnetIds: Option[List[SubnetId]]
    def networkInterfaceIds: Option[List[NetworkInterfaceId]]
    def dnsName: Option[DNSName]
    def kmsKeyId: Option[KmsKeyId]
    def resourceARN: Option[ResourceARN]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def windowsConfiguration
        : Option[zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly]
    def lustreConfiguration
        : Option[zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly]
    def administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def ontapConfiguration
        : Option[zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly]
    def fileSystemTypeVersion: Option[FileSystemTypeVersion]
    def openZFSConfiguration
        : Option[zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly]
    def getOwnerId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getFileSystemType
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemType] =
      AwsError.unwrapOptionField("fileSystemType", fileSystemType)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStorageCapacity: ZIO[Any, AwsError, StorageCapacity] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getStorageType: ZIO[Any, AwsError, zio.aws.fsx.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getFileSystemTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileSystemTypeVersion", fileSystemTypeVersion)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileSystem
  ) extends zio.aws.fsx.model.FileSystem.ReadOnly {
    override val ownerId: Option[AWSAccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.fsx.model.primitives.AWSAccountId(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val fileSystemType: Option[zio.aws.fsx.model.FileSystemType] =
      scala
        .Option(impl.fileSystemType())
        .map(value => zio.aws.fsx.model.FileSystemType.wrap(value))
    override val lifecycle: Option[zio.aws.fsx.model.FileSystemLifecycle] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileSystemLifecycle.wrap(value))
    override val failureDetails
        : Option[zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly] = scala
      .Option(impl.failureDetails())
      .map(value => zio.aws.fsx.model.FileSystemFailureDetails.wrap(value))
    override val storageCapacity: Option[StorageCapacity] = scala
      .Option(impl.storageCapacity())
      .map(value => zio.aws.fsx.model.primitives.StorageCapacity(value))
    override val storageType: Option[zio.aws.fsx.model.StorageType] = scala
      .Option(impl.storageType())
      .map(value => zio.aws.fsx.model.StorageType.wrap(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fsx.model.primitives.VpcId(value))
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.SubnetId(item)
        }.toList
      )
    override val networkInterfaceIds: Option[List[NetworkInterfaceId]] = scala
      .Option(impl.networkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.NetworkInterfaceId(item)
        }.toList
      )
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val windowsConfiguration
        : Option[zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly] =
      scala
        .Option(impl.windowsConfiguration())
        .map(value =>
          zio.aws.fsx.model.WindowsFileSystemConfiguration.wrap(value)
        )
    override val lustreConfiguration
        : Option[zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly] =
      scala
        .Option(impl.lustreConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreFileSystemConfiguration.wrap(value)
        )
    override val administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] = scala
      .Option(impl.administrativeActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.AdministrativeAction.wrap(item)
        }.toList
      )
    override val ontapConfiguration
        : Option[zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly] =
      scala
        .Option(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.OntapFileSystemConfiguration.wrap(value)
        )
    override val fileSystemTypeVersion: Option[FileSystemTypeVersion] = scala
      .Option(impl.fileSystemTypeVersion())
      .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val openZFSConfiguration
        : Option[zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly] =
      scala
        .Option(impl.openZFSConfiguration())
        .map(value =>
          zio.aws.fsx.model.OpenZFSFileSystemConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileSystem
  ): zio.aws.fsx.model.FileSystem.ReadOnly = new Wrapper(impl)
}
