package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{IpAddress, DNSName}
import scala.jdk.CollectionConverters._
final case class FileSystemEndpoint(
    dnsName: Option[DNSName] = None,
    ipAddresses: Option[Iterable[IpAddress]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileSystemEndpoint = {
    import FileSystemEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileSystemEndpoint
      .builder()
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileSystemEndpoint.ReadOnly =
    zio.aws.fsx.model.FileSystemEndpoint.wrap(buildAwsValue())
}
object FileSystemEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileSystemEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileSystemEndpoint =
      zio.aws.fsx.model.FileSystemEndpoint(
        dnsName.map(value => value),
        ipAddresses.map(value => value)
      )
    def dnsName: Option[DNSName]
    def ipAddresses: Option[List[IpAddress]]
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemEndpoint
  ) extends zio.aws.fsx.model.FileSystemEndpoint.ReadOnly {
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val ipAddresses: Option[List[IpAddress]] = scala
      .Option(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemEndpoint
  ): zio.aws.fsx.model.FileSystemEndpoint.ReadOnly = new Wrapper(impl)
}
