package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters._
final case class FileSystemFailureDetails(
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails = {
    import FileSystemFailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly =
    zio.aws.fsx.model.FileSystemFailureDetails.wrap(buildAwsValue())
}
object FileSystemFailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileSystemFailureDetails =
      zio.aws.fsx.model.FileSystemFailureDetails(message.map(value => value))
    def message: Option[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails
  ) extends zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly {
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails
  ): zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly = new Wrapper(impl)
}
