package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, ResourceARN}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceARN: ResourceARN,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.fsx.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.ListTagsForResourceRequest =
      zio.aws.fsx.model.ListTagsForResourceRequest(
        resourceARN,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceARN: ResourceARN
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest
  ) extends zio.aws.fsx.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.fsx.model.primitives.ResourceARN(impl.resourceARN())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest
  ): zio.aws.fsx.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
