package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DailyTime,
  AutomaticBackupRetentionDays,
  PerUnitStorageThroughput,
  LustreFileSystemMountName,
  WeeklyTime,
  Flag
}
import scala.jdk.CollectionConverters._
final case class LustreFileSystemConfiguration(
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    dataRepositoryConfiguration: Option[
      zio.aws.fsx.model.DataRepositoryConfiguration
    ] = None,
    deploymentType: Option[zio.aws.fsx.model.LustreDeploymentType] = None,
    perUnitStorageThroughput: Option[PerUnitStorageThroughput] = None,
    mountName: Option[LustreFileSystemMountName] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    copyTagsToBackups: Option[Flag] = None,
    driveCacheType: Option[zio.aws.fsx.model.DriveCacheType] = None,
    dataCompressionType: Option[zio.aws.fsx.model.DataCompressionType] = None,
    logConfiguration: Option[zio.aws.fsx.model.LustreLogConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration = {
    import LustreFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dataRepositoryConfiguration.map(value => value.buildAwsValue())
      )(_.dataRepositoryConfiguration)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        perUnitStorageThroughput.map(value =>
          PerUnitStorageThroughput.unwrap(value): Integer
        )
      )(_.perUnitStorageThroughput)
      .optionallyWith(
        mountName.map(value =>
          LustreFileSystemMountName.unwrap(value): java.lang.String
        )
      )(_.mountName)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(driveCacheType.map(value => value.unwrap))(
        _.driveCacheType
      )
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.LustreFileSystemConfiguration.wrap(buildAwsValue())
}
object LustreFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.LustreFileSystemConfiguration =
      zio.aws.fsx.model.LustreFileSystemConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        dataRepositoryConfiguration.map(value => value.asEditable),
        deploymentType.map(value => value),
        perUnitStorageThroughput.map(value => value),
        mountName.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        driveCacheType.map(value => value),
        dataCompressionType.map(value => value),
        logConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def dataRepositoryConfiguration
        : Option[zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly]
    def deploymentType: Option[zio.aws.fsx.model.LustreDeploymentType]
    def perUnitStorageThroughput: Option[PerUnitStorageThroughput]
    def mountName: Option[LustreFileSystemMountName]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Option[Flag]
    def driveCacheType: Option[zio.aws.fsx.model.DriveCacheType]
    def dataCompressionType: Option[zio.aws.fsx.model.DataCompressionType]
    def logConfiguration
        : Option[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDataRepositoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataRepositoryConfiguration",
      dataRepositoryConfiguration
    )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.LustreDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getPerUnitStorageThroughput
        : ZIO[Any, AwsError, PerUnitStorageThroughput] = AwsError
      .unwrapOptionField("perUnitStorageThroughput", perUnitStorageThroughput)
    def getMountName: ZIO[Any, AwsError, LustreFileSystemMountName] =
      AwsError.unwrapOptionField("mountName", mountName)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getDriveCacheType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DriveCacheType] =
      AwsError.unwrapOptionField("driveCacheType", driveCacheType)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ) extends zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dataRepositoryConfiguration
        : Option[zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly] = scala
      .Option(impl.dataRepositoryConfiguration())
      .map(value => zio.aws.fsx.model.DataRepositoryConfiguration.wrap(value))
    override val deploymentType
        : Option[zio.aws.fsx.model.LustreDeploymentType] = scala
      .Option(impl.deploymentType())
      .map(value => zio.aws.fsx.model.LustreDeploymentType.wrap(value))
    override val perUnitStorageThroughput: Option[PerUnitStorageThroughput] =
      scala
        .Option(impl.perUnitStorageThroughput())
        .map(value =>
          zio.aws.fsx.model.primitives.PerUnitStorageThroughput(value)
        )
    override val mountName: Option[LustreFileSystemMountName] = scala
      .Option(impl.mountName())
      .map(value =>
        zio.aws.fsx.model.primitives.LustreFileSystemMountName(value)
      )
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Option[Flag] = scala
      .Option(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val driveCacheType: Option[zio.aws.fsx.model.DriveCacheType] =
      scala
        .Option(impl.driveCacheType())
        .map(value => zio.aws.fsx.model.DriveCacheType.wrap(value))
    override val dataCompressionType
        : Option[zio.aws.fsx.model.DataCompressionType] = scala
      .Option(impl.dataCompressionType())
      .map(value => zio.aws.fsx.model.DataCompressionType.wrap(value))
    override val logConfiguration
        : Option[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly] = scala
      .Option(impl.logConfiguration())
      .map(value => zio.aws.fsx.model.LustreLogConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ): zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
