package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SubnetId,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  RouteTableId,
  WeeklyTime,
  IpAddressRange
}
import scala.jdk.CollectionConverters._
final case class OntapFileSystemConfiguration(
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    deploymentType: Option[zio.aws.fsx.model.OntapDeploymentType] = None,
    endpointIpAddressRange: Option[IpAddressRange] = None,
    endpoints: Option[zio.aws.fsx.model.FileSystemEndpoints] = None,
    diskIopsConfiguration: Option[zio.aws.fsx.model.DiskIopsConfiguration] =
      None,
    preferredSubnetId: Option[SubnetId] = None,
    routeTableIds: Option[Iterable[RouteTableId]] = None,
    throughputCapacity: Option[MegabytesPerSecond] = None,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration = {
    import OntapFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        endpointIpAddressRange.map(value =>
          IpAddressRange.unwrap(value): java.lang.String
        )
      )(_.endpointIpAddressRange)
      .optionallyWith(endpoints.map(value => value.buildAwsValue()))(
        _.endpoints
      )
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.OntapFileSystemConfiguration.wrap(buildAwsValue())
}
object OntapFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OntapFileSystemConfiguration =
      zio.aws.fsx.model.OntapFileSystemConfiguration(
        automaticBackupRetentionDays.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType.map(value => value),
        endpointIpAddressRange.map(value => value),
        endpoints.map(value => value.asEditable),
        diskIopsConfiguration.map(value => value.asEditable),
        preferredSubnetId.map(value => value),
        routeTableIds.map(value => value),
        throughputCapacity.map(value => value),
        weeklyMaintenanceStartTime.map(value => value)
      )
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def deploymentType: Option[zio.aws.fsx.model.OntapDeploymentType]
    def endpointIpAddressRange: Option[IpAddressRange]
    def endpoints: Option[zio.aws.fsx.model.FileSystemEndpoints.ReadOnly]
    def diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def preferredSubnetId: Option[SubnetId]
    def routeTableIds: Option[List[RouteTableId]]
    def throughputCapacity: Option[MegabytesPerSecond]
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OntapDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getEndpointIpAddressRange: ZIO[Any, AwsError, IpAddressRange] = AwsError
      .unwrapOptionField("endpointIpAddressRange", endpointIpAddressRange)
    def getEndpoints
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemEndpoints.ReadOnly] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ) extends zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType: Option[zio.aws.fsx.model.OntapDeploymentType] =
      scala
        .Option(impl.deploymentType())
        .map(value => zio.aws.fsx.model.OntapDeploymentType.wrap(value))
    override val endpointIpAddressRange: Option[IpAddressRange] = scala
      .Option(impl.endpointIpAddressRange())
      .map(value => zio.aws.fsx.model.primitives.IpAddressRange(value))
    override val endpoints
        : Option[zio.aws.fsx.model.FileSystemEndpoints.ReadOnly] = scala
      .Option(impl.endpoints())
      .map(value => zio.aws.fsx.model.FileSystemEndpoints.wrap(value))
    override val diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] = scala
      .Option(impl.diskIopsConfiguration())
      .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val preferredSubnetId: Option[SubnetId] = scala
      .Option(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val routeTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.RouteTableId(item)
        }.toList
      )
    override val throughputCapacity: Option[MegabytesPerSecond] = scala
      .Option(impl.throughputCapacity())
      .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ): zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly = new Wrapper(impl)
}
