package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  JunctionPath,
  StorageVirtualMachineId,
  VolumeCapacity,
  Flag,
  UUID
}
import scala.jdk.CollectionConverters._
final case class OntapVolumeConfiguration(
    flexCacheEndpointType: Option[zio.aws.fsx.model.FlexCacheEndpointType] =
      None,
    junctionPath: Option[JunctionPath] = None,
    securityStyle: Option[zio.aws.fsx.model.SecurityStyle] = None,
    sizeInMegabytes: Option[VolumeCapacity] = None,
    storageEfficiencyEnabled: Option[Flag] = None,
    storageVirtualMachineId: Option[StorageVirtualMachineId] = None,
    storageVirtualMachineRoot: Option[Flag] = None,
    tieringPolicy: Option[zio.aws.fsx.model.TieringPolicy] = None,
    uuid: Option[UUID] = None,
    ontapVolumeType: Option[zio.aws.fsx.model.OntapVolumeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration = {
    import OntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
      .builder()
      .optionallyWith(flexCacheEndpointType.map(value => value.unwrap))(
        _.flexCacheEndpointType
      )
      .optionallyWith(
        junctionPath.map(value => JunctionPath.unwrap(value): java.lang.String)
      )(_.junctionPath)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .optionallyWith(
        sizeInMegabytes.map(value => VolumeCapacity.unwrap(value): Integer)
      )(_.sizeInMegabytes)
      .optionallyWith(
        storageEfficiencyEnabled.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageEfficiencyEnabled)
      .optionallyWith(
        storageVirtualMachineId.map(value =>
          StorageVirtualMachineId.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineId)
      .optionallyWith(
        storageVirtualMachineRoot.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageVirtualMachineRoot)
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .optionallyWith(uuid.map(value => UUID.unwrap(value): java.lang.String))(
        _.uuid
      )
      .optionallyWith(ontapVolumeType.map(value => value.unwrap))(
        _.ontapVolumeType
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.OntapVolumeConfiguration.wrap(buildAwsValue())
}
object OntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OntapVolumeConfiguration =
      zio.aws.fsx.model.OntapVolumeConfiguration(
        flexCacheEndpointType.map(value => value),
        junctionPath.map(value => value),
        securityStyle.map(value => value),
        sizeInMegabytes.map(value => value),
        storageEfficiencyEnabled.map(value => value),
        storageVirtualMachineId.map(value => value),
        storageVirtualMachineRoot.map(value => value),
        tieringPolicy.map(value => value.asEditable),
        uuid.map(value => value),
        ontapVolumeType.map(value => value)
      )
    def flexCacheEndpointType: Option[zio.aws.fsx.model.FlexCacheEndpointType]
    def junctionPath: Option[JunctionPath]
    def securityStyle: Option[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: Option[VolumeCapacity]
    def storageEfficiencyEnabled: Option[Flag]
    def storageVirtualMachineId: Option[StorageVirtualMachineId]
    def storageVirtualMachineRoot: Option[Flag]
    def tieringPolicy: Option[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def uuid: Option[UUID]
    def ontapVolumeType: Option[zio.aws.fsx.model.OntapVolumeType]
    def getFlexCacheEndpointType
        : ZIO[Any, AwsError, zio.aws.fsx.model.FlexCacheEndpointType] =
      AwsError.unwrapOptionField("flexCacheEndpointType", flexCacheEndpointType)
    def getJunctionPath: ZIO[Any, AwsError, JunctionPath] =
      AwsError.unwrapOptionField("junctionPath", junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, AwsError, VolumeCapacity] =
      AwsError.unwrapOptionField("sizeInMegabytes", sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageEfficiencyEnabled", storageEfficiencyEnabled)
    def getStorageVirtualMachineId
        : ZIO[Any, AwsError, StorageVirtualMachineId] = AwsError
      .unwrapOptionField("storageVirtualMachineId", storageVirtualMachineId)
    def getStorageVirtualMachineRoot: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageVirtualMachineRoot", storageVirtualMachineRoot)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
    def getUuid: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getOntapVolumeType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OntapVolumeType] =
      AwsError.unwrapOptionField("ontapVolumeType", ontapVolumeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ) extends zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly {
    override val flexCacheEndpointType
        : Option[zio.aws.fsx.model.FlexCacheEndpointType] = scala
      .Option(impl.flexCacheEndpointType())
      .map(value => zio.aws.fsx.model.FlexCacheEndpointType.wrap(value))
    override val junctionPath: Option[JunctionPath] = scala
      .Option(impl.junctionPath())
      .map(value => zio.aws.fsx.model.primitives.JunctionPath(value))
    override val securityStyle: Option[zio.aws.fsx.model.SecurityStyle] = scala
      .Option(impl.securityStyle())
      .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: Option[VolumeCapacity] = scala
      .Option(impl.sizeInMegabytes())
      .map(value => zio.aws.fsx.model.primitives.VolumeCapacity(value))
    override val storageEfficiencyEnabled: Option[Flag] = scala
      .Option(impl.storageEfficiencyEnabled())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val storageVirtualMachineId: Option[StorageVirtualMachineId] =
      scala
        .Option(impl.storageVirtualMachineId())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(value)
        )
    override val storageVirtualMachineRoot: Option[Flag] = scala
      .Option(impl.storageVirtualMachineRoot())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val tieringPolicy
        : Option[zio.aws.fsx.model.TieringPolicy.ReadOnly] = scala
      .Option(impl.tieringPolicy())
      .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
    override val uuid: Option[UUID] = scala
      .Option(impl.uuid())
      .map(value => zio.aws.fsx.model.primitives.UUID(value))
    override val ontapVolumeType: Option[zio.aws.fsx.model.OntapVolumeType] =
      scala
        .Option(impl.ontapVolumeType())
        .map(value => zio.aws.fsx.model.OntapVolumeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ): zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
