package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.{OpenZFSNfsExportOption, OpenZFSClients}
import scala.jdk.CollectionConverters._
final case class OpenZFSClientConfiguration(
    clients: OpenZFSClients,
    options: Iterable[OpenZFSNfsExportOption]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration = {
    import OpenZFSClientConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration
      .builder()
      .clients(OpenZFSClients.unwrap(clients): java.lang.String)
      .options(options.map { item =>
        OpenZFSNfsExportOption.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly =
    zio.aws.fsx.model.OpenZFSClientConfiguration.wrap(buildAwsValue())
}
object OpenZFSClientConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSClientConfiguration =
      zio.aws.fsx.model.OpenZFSClientConfiguration(clients, options)
    def clients: OpenZFSClients
    def options: List[OpenZFSNfsExportOption]
    def getClients: ZIO[Any, Nothing, OpenZFSClients] = ZIO.succeed(clients)
    def getOptions: ZIO[Any, Nothing, List[OpenZFSNfsExportOption]] =
      ZIO.succeed(options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration
  ) extends zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly {
    override val clients: OpenZFSClients =
      zio.aws.fsx.model.primitives.OpenZFSClients(impl.clients())
    override val options: List[OpenZFSNfsExportOption] = impl
      .options()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.OpenZFSNfsExportOption(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration
  ): zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly = new Wrapper(impl)
}
