package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.Flag
import scala.jdk.CollectionConverters._
final case class OpenZFSCreateRootVolumeConfiguration(
    dataCompressionType: Option[zio.aws.fsx.model.OpenZFSDataCompressionType] =
      None,
    nfsExports: Option[Iterable[zio.aws.fsx.model.OpenZFSNfsExport]] = None,
    userAndGroupQuotas: Option[
      Iterable[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
    ] = None,
    copyTagsToSnapshots: Option[Flag] = None,
    readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration = {
    import OpenZFSCreateRootVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration
      .builder()
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(
        nfsExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsExports)
      .optionallyWith(
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAndGroupQuotas)
      .optionallyWith(
        copyTagsToSnapshots.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToSnapshots)
      .optionallyWith(
        readOnly.map(value =>
          zio.aws.fsx.model.primitives.ReadOnly.unwrap(value): java.lang.Boolean
        )
      )(_.readOnly)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.wrap(buildAwsValue())
}
object OpenZFSCreateRootVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration =
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration(
        dataCompressionType.map(value => value),
        nfsExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsToSnapshots.map(value => value),
        readOnly.map(value => value)
      )
    def dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType]
    def nfsExports: Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]]
    def userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]]
    def copyTagsToSnapshots: Option[Flag]
    def readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly]
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getNfsExports: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly
    ]] = AwsError.unwrapOptionField("nfsExports", nfsExports)
    def getUserAndGroupQuotas: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("userAndGroupQuotas", userAndGroupQuotas)
    def getCopyTagsToSnapshots: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToSnapshots", copyTagsToSnapshots)
    def getReadOnly: ZIO[Any, AwsError, zio.aws.fsx.model.primitives.ReadOnly] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration
  ) extends zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly {
    override val dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType] = scala
      .Option(impl.dataCompressionType())
      .map(value => zio.aws.fsx.model.OpenZFSDataCompressionType.wrap(value))
    override val nfsExports
        : Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]] = scala
      .Option(impl.nfsExports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.OpenZFSNfsExport.wrap(item)
        }.toList
      )
    override val userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]] =
      scala
        .Option(impl.userAndGroupQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(item)
          }.toList
        )
    override val copyTagsToSnapshots: Option[Flag] = scala
      .Option(impl.copyTagsToSnapshots())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = scala
      .Option(impl.readOnly())
      .map(value => zio.aws.fsx.model.primitives.ReadOnly(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration
  ): zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly =
    new Wrapper(impl)
}
