package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumePath, Flag, VolumeId, IntegerNoMax}
import scala.jdk.CollectionConverters._
final case class OpenZFSVolumeConfiguration(
    parentVolumeId: Option[VolumeId] = None,
    volumePath: Option[VolumePath] = None,
    storageCapacityReservationGiB: Option[IntegerNoMax] = None,
    storageCapacityQuotaGiB: Option[IntegerNoMax] = None,
    dataCompressionType: Option[zio.aws.fsx.model.OpenZFSDataCompressionType] =
      None,
    copyTagsToSnapshots: Option[Flag] = None,
    originSnapshot: Option[
      zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration
    ] = None,
    readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = None,
    nfsExports: Option[Iterable[zio.aws.fsx.model.OpenZFSNfsExport]] = None,
    userAndGroupQuotas: Option[
      Iterable[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration = {
    import OpenZFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration
      .builder()
      .optionallyWith(
        parentVolumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.parentVolumeId)
      .optionallyWith(
        volumePath.map(value => VolumePath.unwrap(value): java.lang.String)
      )(_.volumePath)
      .optionallyWith(
        storageCapacityReservationGiB.map(value =>
          IntegerNoMax.unwrap(value): Integer
        )
      )(_.storageCapacityReservationGiB)
      .optionallyWith(
        storageCapacityQuotaGiB.map(value =>
          IntegerNoMax.unwrap(value): Integer
        )
      )(_.storageCapacityQuotaGiB)
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(
        copyTagsToSnapshots.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToSnapshots)
      .optionallyWith(originSnapshot.map(value => value.buildAwsValue()))(
        _.originSnapshot
      )
      .optionallyWith(
        readOnly.map(value =>
          zio.aws.fsx.model.primitives.ReadOnly.unwrap(value): java.lang.Boolean
        )
      )(_.readOnly)
      .optionallyWith(
        nfsExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsExports)
      .optionallyWith(
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAndGroupQuotas)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.OpenZFSVolumeConfiguration.wrap(buildAwsValue())
}
object OpenZFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSVolumeConfiguration =
      zio.aws.fsx.model.OpenZFSVolumeConfiguration(
        parentVolumeId.map(value => value),
        volumePath.map(value => value),
        storageCapacityReservationGiB.map(value => value),
        storageCapacityQuotaGiB.map(value => value),
        dataCompressionType.map(value => value),
        copyTagsToSnapshots.map(value => value),
        originSnapshot.map(value => value.asEditable),
        readOnly.map(value => value),
        nfsExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parentVolumeId: Option[VolumeId]
    def volumePath: Option[VolumePath]
    def storageCapacityReservationGiB: Option[IntegerNoMax]
    def storageCapacityQuotaGiB: Option[IntegerNoMax]
    def dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType]
    def copyTagsToSnapshots: Option[Flag]
    def originSnapshot
        : Option[zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly]
    def readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly]
    def nfsExports: Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]]
    def userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]]
    def getParentVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("parentVolumeId", parentVolumeId)
    def getVolumePath: ZIO[Any, AwsError, VolumePath] =
      AwsError.unwrapOptionField("volumePath", volumePath)
    def getStorageCapacityReservationGiB: ZIO[Any, AwsError, IntegerNoMax] =
      AwsError.unwrapOptionField(
        "storageCapacityReservationGiB",
        storageCapacityReservationGiB
      )
    def getStorageCapacityQuotaGiB: ZIO[Any, AwsError, IntegerNoMax] = AwsError
      .unwrapOptionField("storageCapacityQuotaGiB", storageCapacityQuotaGiB)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getCopyTagsToSnapshots: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToSnapshots", copyTagsToSnapshots)
    def getOriginSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("originSnapshot", originSnapshot)
    def getReadOnly: ZIO[Any, AwsError, zio.aws.fsx.model.primitives.ReadOnly] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getNfsExports: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly
    ]] = AwsError.unwrapOptionField("nfsExports", nfsExports)
    def getUserAndGroupQuotas: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("userAndGroupQuotas", userAndGroupQuotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration
  ) extends zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly {
    override val parentVolumeId: Option[VolumeId] = scala
      .Option(impl.parentVolumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val volumePath: Option[VolumePath] = scala
      .Option(impl.volumePath())
      .map(value => zio.aws.fsx.model.primitives.VolumePath(value))
    override val storageCapacityReservationGiB: Option[IntegerNoMax] = scala
      .Option(impl.storageCapacityReservationGiB())
      .map(value => zio.aws.fsx.model.primitives.IntegerNoMax(value))
    override val storageCapacityQuotaGiB: Option[IntegerNoMax] = scala
      .Option(impl.storageCapacityQuotaGiB())
      .map(value => zio.aws.fsx.model.primitives.IntegerNoMax(value))
    override val dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType] = scala
      .Option(impl.dataCompressionType())
      .map(value => zio.aws.fsx.model.OpenZFSDataCompressionType.wrap(value))
    override val copyTagsToSnapshots: Option[Flag] = scala
      .Option(impl.copyTagsToSnapshots())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val originSnapshot: Option[
      zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly
    ] = scala
      .Option(impl.originSnapshot())
      .map(value =>
        zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.wrap(value)
      )
    override val readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = scala
      .Option(impl.readOnly())
      .map(value => zio.aws.fsx.model.primitives.ReadOnly(value))
    override val nfsExports
        : Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]] = scala
      .Option(impl.nfsExports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.OpenZFSNfsExport.wrap(item)
        }.toList
      )
    override val userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]] =
      scala
        .Option(impl.userAndGroupQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration
  ): zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
