package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ClientRequestToken, FileSystemId}
import scala.jdk.CollectionConverters._
final case class ReleaseFileSystemNfsV3LocksRequest(
    fileSystemId: FileSystemId,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest = {
    import ReleaseFileSystemNfsV3LocksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest.ReadOnly =
    zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest.wrap(buildAwsValue())
}
object ReleaseFileSystemNfsV3LocksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest =
      zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest(
        fileSystemId,
        clientRequestToken.map(value => value)
      )
    def fileSystemId: FileSystemId
    def clientRequestToken: Option[ClientRequestToken]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
  ) extends zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
  ): zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksRequest.ReadOnly =
    new Wrapper(impl)
}
