package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReleaseFileSystemNfsV3LocksResponse(
    fileSystem: Option[zio.aws.fsx.model.FileSystem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse = {
    import ReleaseFileSystemNfsV3LocksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
      .builder()
      .optionallyWith(fileSystem.map(value => value.buildAwsValue()))(
        _.fileSystem
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly =
    zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.wrap(buildAwsValue())
}
object ReleaseFileSystemNfsV3LocksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse =
      zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse(
        fileSystem.map(value => value.asEditable)
      )
    def fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly]
    def getFileSystem
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
      AwsError.unwrapOptionField("fileSystem", fileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
  ) extends zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly {
    override val fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly] =
      scala
        .Option(impl.fileSystem())
        .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
  ): zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly =
    new Wrapper(impl)
}
