package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{SnapshotId, VolumeId, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class RestoreVolumeFromSnapshotRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    volumeId: VolumeId,
    snapshotId: SnapshotId,
    options: Option[Iterable[zio.aws.fsx.model.RestoreOpenZFSVolumeOption]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest = {
    import RestoreVolumeFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest.ReadOnly =
    zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest.wrap(buildAwsValue())
}
object RestoreVolumeFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest =
      zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest(
        clientRequestToken.map(value => value),
        volumeId,
        snapshotId,
        options.map(value => value)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def volumeId: VolumeId
    def snapshotId: SnapshotId
    def options: Option[List[zio.aws.fsx.model.RestoreOpenZFSVolumeOption]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.RestoreOpenZFSVolumeOption
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest
  ) extends zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val volumeId: VolumeId =
      zio.aws.fsx.model.primitives.VolumeId(impl.volumeId())
    override val snapshotId: SnapshotId =
      zio.aws.fsx.model.primitives.SnapshotId(impl.snapshotId())
    override val options
        : Option[List[zio.aws.fsx.model.RestoreOpenZFSVolumeOption]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.RestoreOpenZFSVolumeOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest
  ): zio.aws.fsx.model.RestoreVolumeFromSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
