package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.VolumeId
import scala.jdk.CollectionConverters._
final case class RestoreVolumeFromSnapshotResponse(
    volumeId: Option[VolumeId] = None,
    lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse = {
    import RestoreVolumeFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
      .builder()
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.wrap(buildAwsValue())
}
object RestoreVolumeFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse =
      zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse(
        volumeId.map(value => value),
        lifecycle.map(value => value)
      )
    def volumeId: Option[VolumeId]
    def lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle]
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ) extends zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly {
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.fsx.model.VolumeLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ): zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
