package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  IpAddress,
  FileSystemAdministratorsGroupName,
  ActiveDirectoryFullyQualifiedName,
  OrganizationalUnitDistinguishedName,
  DirectoryUserName
}
import scala.jdk.CollectionConverters._
final case class SelfManagedActiveDirectoryAttributes(
    domainName: Option[ActiveDirectoryFullyQualifiedName] = None,
    organizationalUnitDistinguishedName: Option[
      OrganizationalUnitDistinguishedName
    ] = None,
    fileSystemAdministratorsGroup: Option[FileSystemAdministratorsGroupName] =
      None,
    userName: Option[DirectoryUserName] = None,
    dnsIps: Option[Iterable[IpAddress]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes = {
    import SelfManagedActiveDirectoryAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
      .builder()
      .optionallyWith(
        domainName.map(value =>
          ActiveDirectoryFullyQualifiedName.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          OrganizationalUnitDistinguishedName.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .optionallyWith(
        fileSystemAdministratorsGroup.map(value =>
          FileSystemAdministratorsGroupName.unwrap(value): java.lang.String
        )
      )(_.fileSystemAdministratorsGroup)
      .optionallyWith(
        userName.map(value => DirectoryUserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly =
    zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.wrap(buildAwsValue())
}
object SelfManagedActiveDirectoryAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes =
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes(
        domainName.map(value => value),
        organizationalUnitDistinguishedName.map(value => value),
        fileSystemAdministratorsGroup.map(value => value),
        userName.map(value => value),
        dnsIps.map(value => value)
      )
    def domainName: Option[ActiveDirectoryFullyQualifiedName]
    def organizationalUnitDistinguishedName
        : Option[OrganizationalUnitDistinguishedName]
    def fileSystemAdministratorsGroup: Option[FileSystemAdministratorsGroupName]
    def userName: Option[DirectoryUserName]
    def dnsIps: Option[List[IpAddress]]
    def getDomainName: ZIO[Any, AwsError, ActiveDirectoryFullyQualifiedName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getOrganizationalUnitDistinguishedName
        : ZIO[Any, AwsError, OrganizationalUnitDistinguishedName] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedName",
        organizationalUnitDistinguishedName
      )
    def getFileSystemAdministratorsGroup
        : ZIO[Any, AwsError, FileSystemAdministratorsGroupName] =
      AwsError.unwrapOptionField(
        "fileSystemAdministratorsGroup",
        fileSystemAdministratorsGroup
      )
    def getUserName: ZIO[Any, AwsError, DirectoryUserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getDnsIps: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ) extends zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly {
    override val domainName: Option[ActiveDirectoryFullyQualifiedName] = scala
      .Option(impl.domainName())
      .map(value =>
        zio.aws.fsx.model.primitives.ActiveDirectoryFullyQualifiedName(value)
      )
    override val organizationalUnitDistinguishedName
        : Option[OrganizationalUnitDistinguishedName] = scala
      .Option(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.fsx.model.primitives.OrganizationalUnitDistinguishedName(value)
      )
    override val fileSystemAdministratorsGroup
        : Option[FileSystemAdministratorsGroupName] = scala
      .Option(impl.fileSystemAdministratorsGroup())
      .map(value =>
        zio.aws.fsx.model.primitives.FileSystemAdministratorsGroupName(value)
      )
    override val userName: Option[DirectoryUserName] = scala
      .Option(impl.userName())
      .map(value => zio.aws.fsx.model.primitives.DirectoryUserName(value))
    override val dnsIps: Option[List[IpAddress]] = scala
      .Option(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ): zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly =
    new Wrapper(impl)
}
