package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  CreationTime,
  SnapshotName,
  ResourceARN,
  VolumeId,
  SnapshotId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Snapshot(
    resourceARN: Option[ResourceARN] = None,
    snapshotId: Option[SnapshotId] = None,
    name: Option[SnapshotName] = None,
    volumeId: Option[VolumeId] = None,
    creationTime: Option[CreationTime] = None,
    lifecycle: Option[zio.aws.fsx.model.SnapshotLifecycle] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    administrativeActions: Option[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Snapshot
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        name.map(value => SnapshotName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Snapshot.ReadOnly =
    zio.aws.fsx.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Snapshot = zio.aws.fsx.model.Snapshot(
      resourceARN.map(value => value),
      snapshotId.map(value => value),
      name.map(value => value),
      volumeId.map(value => value),
      creationTime.map(value => value),
      lifecycle.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      administrativeActions.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def resourceARN: Option[ResourceARN]
    def snapshotId: Option[SnapshotId]
    def name: Option[SnapshotName]
    def volumeId: Option[VolumeId]
    def creationTime: Option[CreationTime]
    def lifecycle: Option[zio.aws.fsx.model.SnapshotLifecycle]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getName: ZIO[Any, AwsError, SnapshotName] =
      AwsError.unwrapOptionField("name", name)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.SnapshotLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Snapshot
  ) extends zio.aws.fsx.model.Snapshot.ReadOnly {
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.fsx.model.primitives.SnapshotId(value))
    override val name: Option[SnapshotName] = scala
      .Option(impl.name())
      .map(value => zio.aws.fsx.model.primitives.SnapshotName(value))
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val lifecycle: Option[zio.aws.fsx.model.SnapshotLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.fsx.model.SnapshotLifecycle.wrap(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] = scala
      .Option(impl.administrativeActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.AdministrativeAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Snapshot
  ): zio.aws.fsx.model.Snapshot.ReadOnly = new Wrapper(impl)
}
