package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.SnapshotLifecycle
}
object SnapshotLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.SnapshotLifecycle
  ): zio.aws.fsx.model.SnapshotLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.SnapshotLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotLifecycle =
      software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.fsx.model.SnapshotLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotLifecycle =
      software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.PENDING
  }
  case object CREATING extends zio.aws.fsx.model.SnapshotLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotLifecycle =
      software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.CREATING
  }
  case object DELETING extends zio.aws.fsx.model.SnapshotLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotLifecycle =
      software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.DELETING
  }
  case object AVAILABLE extends zio.aws.fsx.model.SnapshotLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotLifecycle =
      software.amazon.awssdk.services.fsx.model.SnapshotLifecycle.AVAILABLE
  }
}
